<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Contact_Form_Controller extends Pf_Plugin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->view->set_path('contactform');
        $this->data['validated'] = array();
        $this->model = new Pf_Contact_Form_Model();
        $this->validator = Pf::validator();
        $this->acl = array(1, 2);
        $this->check_acl();
    }

    public function main()
    {
        $data = get_option('contactform');
        $contactforms = $data;
        $url = admin_url('admin-page=contactform', false);
        if ($this->input->has_get('kw')) {
            $contactforms = array_filter($data, 'search_contact_callback');
            $url .= "&kw={$this->input->get('kw')}";
        }
        if ($this->input->has_get('status')) {
            $status = (int) $this->input->get('status') === 1 ? 1 : 0;
            $contactforms = search_by_key($contactforms, $status, 'status');
            $url .= "&status={$status}";
        }
        $total = count($contactforms);
        $curent_page = ($this->input->has_get('current') && $this->input->get('current') <= $total) ? (int) $this->input->get('current') : 1;
        $pagination = new Pf_Paginator($total, NUM_PER_PAGE, 'current');
        $this->data['contactforms'] = pagination($contactforms, $curent_page);
        $this->data['pagination'] = $pagination;
        $this->data['url'] = $url;
        $this->view->render('main', $this->data);
    }

    /*
     * CURD
     */

    private function build_validator($atts)
    {
        $validator = array();
        $correct = array('email' => 'email', 'url' => 'url', 'number' => '', 'date' => '', 'text' => '', 'textarea' => '');
        $att = array();
        foreach ($atts as $item) {
            $att = $item['attr'];
            if (!isset($att['type']) || $att['type'] == '') {
                return;
            } elseif ($att['type'] === 'captcha') {
                $att['name'] = 'captcha';
            } elseif ($att['type'] === 'acceptance') {
                $att['name'] = 'acceptance';
            }
            if (!isset($att['name']) || $att['name'] == '') {
                continue;
            }
            if ($att['type'] == 'acceptance') {
                $validator['acceptance'][] = 'required|boolean';
                continue;
            }
            if ($att['type'] == 'captcha') {
                $validator['captcha'] = 'captcha';
                continue;
            }
            $key = clean_control_name($att['name']);
            if (isset($att['required']) && $att['required'] == 1) {
                $validator[$key][] = 'required';
            }
            if ($att['type'] == 'date') {
                $validator[$key][] = 'date';
            }
            if ($att['type'] == 'numeric') {
                $validator[$key][] = 'numeric';
            }
            if (in_array($att['type'], array_keys($correct))) {
                $correct[$att['type']] == '' ? '' : $validator[$key][] = 'valid_' . $correct[$att['type']];
            }
            if (isset($att['maxlength']) && is_numeric($att['maxlength'])) {
                $validator[$key][] = 'max_len,' . $att['maxlength'];
            }
        }
        return $validator;
    }

    private function get_validator($atts)
    {
        $data = $this->build_validator($atts);
        foreach ($data as $key => $item) {
            if ($key == 'check') {
                $data[$key] = $item;
            } else {
                $data[$key] = is_array($item) ? implode('|', $item) : $item;
            }
        }
        return $data;
    }

    private function save()
    {
        if ($this->input->has_post('title')) {
            $data = get_option('contactform');
            if (!is_array($data)) {
                $data = array();
            }
            $input_all = $this->input->post();
            $this->validator->validation_rules($this->model->rules);
            if ($this->validator->run($input_all) !== false) {
                $id = $this->input->has_post('id') ? $this->input->post('id') : uniqid();
                $validator = Pf::shortcode()->scan(sc_get_value_input('form'));
                $data[$id] = array(
                    'title' => sc_get_value_input('title'),
                    'status' => sc_get_value_input('status'),
                    'form' => sc_get_value_input('form'),
                    'form_id' => sc_get_value_input('form_id'),
                    'form_class' => sc_get_value_input('form_class'),
                    'mail' => array(
                        'config' => array(
                            'to' => sc_get_value_input('to'),
                            'from' => sc_get_value_input('from'),
                            'name' => sc_get_value_input('name'),
                            'subject' => sc_get_value_input('subject'),
                            'use_as_html' => isset($input_all['use_as_html']) ? 1 : 0
                        ),
                        'message' => sc_get_value_input('message'),
                        'notify' => sc_get_value_input('notify')
                    ),
                    'validator' => $this->get_validator($validator)
                );
                update_option('contactform', $data);
                $current = $this->input->has_get('current') ? $this->input->get('current') : '';
                $this->session->flash('success', __('Your action is successful', 'contactform'));
                Pf_Plugin_Redirect::to("&act=edit&current={$current}&id={$id}");
            } else {
                $this->data['error'] = __('Please check the data field', 'contactform');
                $this->data['validated'] = $this->validator->get_readable_errors(false);
            }
        }
    }

    public function find($id)
    {
        $data = get_option('contactform');
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                if ($key == $id) {
                    return $value;
                }
            }
        }
        return false;
    }

    public function create()
    {
        $this->save();
        $this->data['status'] = $this->model->get_status_contactform();
        $this->view->render('create', $this->data);
    }

    public function edit()
    {
        if (!$this->input->has_get('id')) {
            Pf_Plugin_Redirect::to('&act=main');
        }
        $id = $this->input->get('id');
        $data = $this->find($id);
        is_array($data) || Pf_Plugin_Redirect::to('&act=main');
        $this->save();
        $this->data['status'] = $this->model->get_status_contactform();
        $this->data['contactform'] = $data;
        $this->data['id'] = $id;
        $this->view->render('edit', $this->data);
    }

    public function delete()
    {
        if ($this->input->has_get('id')) {
            $id = $this->input->get('id');
            is_array($this->find($id)) || Pf_Plugin_Redirect::to('&act&id');
            $data = get_option('contactform');
            unset($data[$id]);
            update_option('contactform', $data);
            $this->session->flash('success', __('Your action is successful', 'contactform'));
        }
        Pf_Plugin_Redirect::to('&act&id');
    }

    //Bulk Action
    private function delete_multiple($data, $ids)
    {
        foreach ($ids as $value) {
            unset($data[$value]);
        }
        update_option('contactform', $data);
    }

    private function update_status($data, $ids, $status)
    {
        foreach ($ids as $value) {
            $data[$value]['status'] = $status;
        }
        update_option('contactform', $data);
    }

    public function bulk_action()
    {
        if ($this->input->has_post('id')) {
            $current = $this->input->has_post('current') ? $this->input->post('current') : 0;
            $action = $this->input->post('action');
            $data = get_option('contactform');
            $id = $this->input->post('id');
            $ids = array_values($id);
            if ($action == 3) {
                $this->delete_multiple($data, $ids);
            } else {
                $this->update_status($data, $ids, $action);
            }
            $this->session->flash('success', __('Your action is successful', 'contactform'));
        }
        Pf_Plugin_Redirect::to("&act&current={$current}");
    }

    /*
     * Status
     */

    public function status()
    {
        $curent = $this->input->get('current');
        if ($this->input->has_get('id') && $this->input->has_get('type')) {
            $id = $this->input->get('id');
            $status = $this->input->get('type') == 2 ? 0 : 1;
            $data = get_option('contactform');
            $this->update_status($data, array($id), $status);
            $this->session->flash('success', __('Status is updated successfully', 'contactform'));
        }
        Pf_Plugin_Redirect::to('&act&id&type&current=' . $curent);
    }

}
